#version 140 compatibility
#include "/includes/main.glsl"





varying vec4 color;
varying vec3 viewVector;

varying vec4 lmtexcoord;
vec3 mul3(const in mat4 matrix, const in vec3 vector)
{
    return mat3(matrix) * vector + matrix[3].xyz;
}
void main()
{
    vec3 shadowViewPos = mul3(gl_ModelViewMatrix, gl_Vertex.xyz);
    viewVector = mul3(shadowModelViewInverse, shadowViewPos);

    color = gl_Color;
    vec4 position = gl_ModelViewProjectionMatrix * gl_Vertex;
    position.z *= 0.1666666666666667; // 1/6
    if (dhMaterialId != 1)
    {
        position.z += 0.001;
    }

    vec2 shadowDistortion = calcShadowDistortion(position.xyz);
    position.xy = shadowDistortion;

    lmtexcoord.xyzw = vec4(gl_MultiTexCoord0.xy, gl_MultiTexCoord1.xy * 1);

    gl_Position = position;
}
